<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPageContenuTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('page_contenus', function (Blueprint $table) {
            $table->id();
            $table->integer('page_id', false, true);
            $table->integer('contenu_id', false, true);
            $table->string('contenu_type');
            $table->boolean('en_suppression')->default(0);
            $table->boolean('en_ajout')->default(1);
            $table->boolean('actif')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('page_contenus');
    }
}
