<?php


namespace Bloom\CMS\Modules\Architecture;


use Bloom\CMS\Modules\Architecture\Contenus\{Ensemble, Filtre};
use Bloom\CMS\Modules\Architecture\Http\Middleware\ModuleMiddleware;
use Bloom\CMS\Modules\Architecture\Model\{Module, Page};
use Illuminate\Support\Facades\{Route, Schema};
use Illuminate\Support\ServiceProvider;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use TwigBridge\Facade\Twig;

class CmsArchiServiceProvider extends ServiceProvider
{

    public function register(): void
    {
        $this->loadFactoriesFrom(dirname(__DIR__) . '/database/factories');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadViewsFrom(dirname(__DIR__) . '/resources/views', 'Archi');
        $this->registerRoutes();
    }

    public function boot(): void
    {
        // On doit enregistré toutes les routes listé en bdd

        if (Schema::hasTable('modules')) {
            $module = Module::nom('archi')->firstOrCreate([
                'nom'        => 'archi',
                'nom_public' => 'Architecture',
                'route'      => 'admin_page_list',
            ]);
            if (!$module->exists) {
                $module->active = 1;
                $module->save();
            }
        }
        $morphed = [
            'filtres' => Filtre::class,
            'ensembles' => Ensemble::class,
        ];

        Page::declareContenus($morphed);

        self::refreshRoutes();

        Twig::addExtension(new class extends AbstractExtension {
            public function getFunctions()
            {
                return [
                    new TwigFunction('modules', function () {
                        return Module::actif()->get()->each(function (Module $module) {
                            $module->menu_actif = request()->module_actif == $module->id;
                        });
                    }),
                    new TwigFunction('route_name', function () {
                        return request()->route()->getName();
                    })
                ];
            }

        });
    }

    public static function refreshRoutes(): void
    {
        if (Schema::hasTable('pages')) {
            Route::group(['namespace' => 'Bloom\CMS\Modules\Architecture\Http\Controllers', 'middleware' => ['web']], function () {
                foreach (Page::published()->get('pathname') as $page) {
                    Route::get($page->pathname, 'FrontController@handle');
                }
            });
        }
    }

    protected function registerRoutes()
    {
        Route::group([
            'namespace'  => 'Bloom\CMS\Modules\Architecture\Http\Controllers',
            'middleware' => ['web', 'auth', ModuleMiddleware::class],
            'prefix'     => config('app.admin'),
        ], function () {
            Route::group(['prefix' => 'dossiers'], function () {
                Route::get('/', 'DossierController@index')->name('admin_dossier_list');
                Route::get('/edit/{dossier?}', 'DossierController@edit')->name('admin_dossier_edit');
                Route::post('/edit/{dossier?}', 'DossierController@save')->name('admin_dossier_save');
                Route::get('/{dossier}/delete', 'DossierController@delete')->name('admin_dossier_del');
            });
            Route::group(['prefix' => 'pages'], function () {
                Route::get('/', 'PageController@index')->name('admin_page_list');
                Route::get('/edit/{page?}', 'PageController@edit')->name('admin_page_edit');
                Route::post('/edit/{page?}', 'PageController@save')->name('admin_page_save');
                Route::get('/contenu/{contenu?}', 'PageController@contenu')->name('admin_page_contenu');
                Route::get('/{page}/archive', 'PageController@archive')->name('admin_page_archive');
            });
        });
    }

}