<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 03/08/2020
 * Time: 11:38
 */

namespace Bloom\CMS\Modules\Architecture\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Model\Dossier;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Architecture\Model\Section;
use Bloom\CMS\Modules\Architecture\Model\SectionDossier;
use Bloom\CMS\Modules\Architecture\Model\SectionLien;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Ramsey\Uuid\Uuid;

class SommaireController extends Controller
{
    public function form(string $type, Page $page)
    {
        $data = compact('page');
        $data['parent_id'] = request('parent_id');
        if ($type === 'perso') {
            // On charge la liste des dossierss
            $data['dossiers'] = Dossier::all();
            $data['pages'] = Page::published()->where('id', '!=', $page->id)->get();
            $data['sections'] = Section::query()->where('page_id', '=', $page->id)->get();
            if ($data['sections']->count() === 0) {
                $section = new Section();
                $section->rang = 1;
                $section->type = 'liste';
                $section->id = Uuid::uuid4()->toString();
                $section->titre = 'Section 1';
                $data['sections'][] = $section;
            } else {
                $data['sections']->each(function ($section) {
                    //On lazy laod l'info
                    $section->info;
                });
            }
        }

        return \view('Archi::admin.form_' . $type, $data);
    }

    protected function fillPage(Page $page)
    {
        $page->deriere_modification_par()->associate(Auth::user());
        $page->intro = request('intro');
        $page->titre = request('titre');
        $page->meta_titre = request('titre');
        $page->meta_description = '';
        $page->slug = '';
        $page->multiplicity = Page::SINGLE;
        $page->statut_id = request('statut_id', 2);
        $page->image_opengraph = request('image_opengraph');
        if ($page->exists) {
            // Edition
            $dossier = $page->dossier;
            $dossier->name = $page->titre;
            $dossier->slug = request('slug');
            $dossier->save();
        } else {
            $page->cree_par()->associate(Auth::user());
            // Création
            $dossier = new Dossier(['name' => $page->titre, 'slug' => request('slug'), 'type' => '']);
            if (request('parent_id')) {
                /**
                 * @var Page $parent
                 */
                $parent = Page::find(request('parent_id'));
                if ($parent) {
                    $dossier->parent_id = $parent->dossier_id;
                }
            }
            $dossier->save();
            $page->dossier()->associate($dossier);
            $page->is_index = true;
        }
    }

    public function saveAuto(Page $page)
    {
        // Sauvegarde des index automatique
        $this->fillPage($page);
        $page->save();


        return redirect()->route('admin_archi_index');
    }

    public function savePerso(Page $page)
    {
        Log::debug("sauvegade d'un nouveau dossier perso", ['request' => request()->all()]);
        // Sauvegarde des index automatique
        $this->fillPage($page);
        try {
            DB::transaction(function () use ($page) {
                $page->save();
                foreach (Section::query()->where('page_id', '=', $page->id)->get() as $section) {
                    /**
                     * @var Section $section
                     */
                    if ($section->info) {
                        // Si la section existe
                        $section->info->delete();
                    }
                }

                $k = 1;
                while (request('rang-' . $k)) {
                    $prefix = request('rang-' . $k);
                    if (($section = Section::find(str_replace('section', '', request('rang-' . $k)))) === null) {
                        $section = new Section();
                        $section->page_id = $page->id;
                    }
                    $section->rang = $k;
                    $section->type = request($prefix . '-type');
                    $section->titre = request($prefix . '-' . $section->type . '-titre');
                    $section->save();
                    switch ($section->type) {
                        case 'lien':
                            $prefix .= '-lien';
                            $sub = new SectionLien();
                            $sub->description = request($prefix . '-description');
                            $sub->cta = request($prefix . '-cta');
                            $sub->cta_bg = request($prefix . '-cta_bg');
                            $sub->cta_color = request($prefix . '-cta_color');
                            $sub->page_id = request($prefix . '-page');
                            $sub->section_id = $section->id;
                            break;
                        case 'liste':
                            // no break;
                        default:
                            $prefix .= '-liste';
                            $sub = new SectionDossier();
                            $sub->dossier_id = request($prefix . '-dossier');
                            $sub->section_id = $section->id;
                            break;
                    }
                    $sub->save();

                    // increments
                    $k++;
                }
                $page->touch();
            });
        } catch (\Throwable $e) {
            Log::error($e->getMessage(), ['error' => $e]);
            session()->flash('error', 'Une erreur est survenue lors de la sauvagarde');
        }

        return redirect()->route('admin_archi_index');
    }
}