<?php

namespace Bloom\CMS\Modules\Architecture;

use Bloom\Cms\Configuration\Facade\Site;
use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;

/**
 * Class CmsArchiServiceProvider
 *
 * @package Bloom\CMS\Modules\Architecture
 */
class CmsArchiServiceProvider extends BloomProvider
{
    /**
     * @inheritdoc
     */
    protected $nom = "Architecture";
    protected $code = "archi";
    protected $icons = "architecture";

    public function boot()
    {
        parent::boot();

        Site::config(
            'Largeur image archi',
            'VIGNETTE_ARCHI_IMG_L',
            'Archi',
            '1140',
            '\d+',
            'La largeur doit être un chiffre',
            false
        );

        $this->addSubMenus([
            new AdminMenu([
                'label' => 'Historiques des urls',
                'route' => 'admin_archi_histo',
            ])
        ]);
    }
}
