<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 31/07/2020
 * Time: 12:32
 */

namespace Bloom\CMS\Modules\Architecture\Http\Controllers;

use Bloom\CMS\Modules\Architecture\Model\Dossier;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Architecture\Model\Statut;
use Illuminate\Routing\Controller;
use Illuminate\View\View;

/**
 * Class AdminController
 * @package Bloom\CMS\Modules\Architecture\Http\Controllers
 */
class AdminController extends Controller
{

    public function index(): View
    {
        $racine = Page::query()->whereIn('statut_id', [Statut::EN_COURS, Statut::PUBLIE])->whereNull('dossier_id')->get();
        $indexs = Page::query()->whereIn('statut_id', [Statut::EN_COURS, Statut::PUBLIE])->where('is_index', '=', 1)->get();

        $pages = $racine->merge($indexs);

        return view('Archi::admin.index', compact('pages'));
    }

    public function tooglePublish(Page $page)
    {
        return $page;
    }

    public function delete(Page $page)
    {
        return $page;
    }
}