<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 03/12/2020
 * Time: 12:35
 */

namespace Tests\Feature;


use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Miroir;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Architecture\CmsArchiServiceProvider;
use Illuminate\Foundation\Auth\User;

class PageActionTest extends \Bloom\CMS\Core\Test
{
    protected $provider = CmsArchiServiceProvider::class;

    public function test_publish_action_should_publish()
    {
        $dossier = factory(Dossier::class)->create();
        $page = factory(Page::class)
            ->state('unpublished')
            ->state('index')
            ->create(['dossier_id' => $dossier->id, 'pathname' => '/' . $dossier->slug]);

        $response = $this->actingAs(User::first())->get(route('admin_archi_publish', $page));
        $response->assertRedirect();

        $page->refresh();

        static::assertEquals(Statut::PUBLIE, (int)$page->statut_id);
    }

    public function test_unpublish_action_should_unpublish()
    {
        $dossier = factory(Dossier::class)->create();
        $page = factory(Page::class)
            ->state('index')
            ->create(['dossier_id' => $dossier->id, 'pathname' => '/' . $dossier->slug]);

        $response = $this->actingAs(User::first())->get(route('admin_archi_unpublish', $page));
        $response->assertRedirect();

        $page->refresh();

        static::assertEquals(Statut::EN_COURS, (int)$page->statut_id);
    }

    public function test_archive_action_should_archive()
    {
        $dossier = factory(Dossier::class)->create();
        $page = factory(Page::class)
            ->state('index')
            ->create(['dossier_id' => $dossier->id, 'pathname' => '/' . $dossier->slug]);

        $response = $this->actingAs(User::first())->get(route('admin_archi_archive', $page));
        $response->assertRedirect();

        $page->refresh();

        static::assertEquals(Statut::ARCHIVE, (int)$page->statut_id);
    }

    public function test_delete_action_should_softdelete()
    {
        $dossier = factory(Dossier::class)->create();
        $page = factory(Page::class)
            ->state('unpublished')
            ->state('index')
            ->create(['dossier_id' => $dossier->id, 'pathname' => '/' . $dossier->slug]);

        $response = $this->actingAs(User::first())->get(route('admin_archi_delete', $page));
        $response->assertRedirect();

        $page->refresh();

        static::assertEquals(Statut::SUPPRIMER, (int)$page->statut_id);
    }

    public function test_move_action_should_change_dir_and_pathname()
    {
        $dossier = factory(Dossier::class)->create();
        /**
         * @var Dossier $dossier_cible
         * @var Page    $page
         */
        $dossier_cible = factory(Dossier::class)->create();
        $page = factory(Page::class)
            ->state('unpublished')
            ->create(['dossier_id' => $dossier->id, 'pathname' => '/' . $dossier->slug]);

        $response = $this->actingAs(User::first())->post(route('admin_archi_move', $page), ['dossier_id' => $dossier_cible->id]);
        $response->assertRedirect();

        $page->refresh();

        static::assertEquals('/' . $dossier_cible->full_pathname . '/' . $page->slug, $page->pathname);
    }

    public function test_move_action_should_change_parent_dir_and_pathname_for_index()
    {
        $dossier = factory(Dossier::class)->create();
        /**
         * @var Dossier $dossier_cible
         * @var Page    $page
         */
        $dossier_cible = factory(Dossier::class)->create();
        $page = factory(Page::class)
            ->state('unpublished')
            ->state('index')
            ->create(['dossier_id' => $dossier->id, 'pathname' => '/' . $dossier->slug]);

        $response = $this->actingAs(User::first())->post(route('admin_archi_move', $page), ['dossier_id' => $dossier_cible->id]);
        $response->assertRedirect();

        $page->refresh();

        static::assertEquals('/' . $dossier_cible->slug . '/' . $dossier->slug, $page->pathname);
    }

    public function getMiroir(int $statut = 1): Miroir
    {
        $dossier = factory(Dossier::class)->create();
        $dossier_cible = factory(Dossier::class)->create();
        $page = factory(Page::class)
            ->state('unpublished')
            ->state('index')
            ->create(['dossier_id' => $dossier->id, 'pathname' => '/' . $dossier->slug]);
        $miroir = new Miroir();
        $miroir->dossier()->associate($dossier_cible);
        $miroir->page()->associate($page);
        $miroir->statut_id = $statut;
        $miroir->cree_par()->associate(User::first());
        $miroir->deriere_modification_par()->associate(User::first());
        $miroir->save();

        return $miroir;
    }

    public function test_publish_miror_action_should_publish()
    {
        $miroir = $this->getMiroir(Statut::EN_COURS);

        $response = $this->actingAs(User::first())->get(route('admin_archi_miroir_publish', $miroir));
        $response->assertRedirect();

        $miroir->refresh();

        static::assertEquals(Statut::PUBLIE, (int)$miroir->statut_id);
    }

    public function test_unpublish_miror_action_should_unpublish()
    {
        $miroir = $this->getMiroir();

        $response = $this->actingAs(User::first())->get(route('admin_archi_miroir_unpublish', $miroir));
        $response->assertRedirect();

        $miroir->refresh();

        static::assertEquals(Statut::EN_COURS, (int)$miroir->statut_id);
    }

    public function test_archive_miror_action_should_archive()
    {
        $miroir = $this->getMiroir();

        $response = $this->actingAs(User::first())->get(route('admin_archi_miroir_archive', $miroir));
        $response->assertRedirect();

        $miroir->refresh();

        static::assertEquals(Statut::ARCHIVE, (int)$miroir->statut_id);
    }

    public function test_delete_miror_action_should_softdelete()
    {
        $miroir = $this->getMiroir();

        $response = $this->actingAs(User::first())->get(route('admin_archi_miroir_delete', $miroir));
        $response->assertRedirect();

        $miroir->refresh();

        static::assertEquals(Statut::SUPPRIMER, (int)$miroir->statut_id);
    }
}
