<?php

namespace Bloom\CMS\Modules\Architecture;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;

/**
 * Class CmsArchiServiceProvider
 *
 * @package Bloom\CMS\Modules\Architecture
 */
class CmsArchiServiceProvider extends BloomProvider
{
    /**
     * @inheritdoc
     */
    protected $nom = "Architecture";
    /**
     * @inheritdoc
     */
    protected $code = "archi";
    protected $icons = "architecture";

    public function boot()
    {
        parent::boot();
        $this->addSubMenus([
            new AdminMenu([
                'label' => 'Historiques des urls',
                'route' => 'admin_archi_histo',
            ])
        ]);
    }
}
