<?php

namespace Tests\Feature;

use Bloom\CMS\Modules\Architecture\CmsArchiServiceProvider;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Eloquent\Relations\Relation;
use Tests\Test;
use Tests\Unit\Contenu;

class PageTest extends Test
{
    public function getContenu(array $attributes = []): Contenu
    {
        Relation::morphMap([
            'contenus' => Contenu::class,
        ]);

        Page::declareContenu('contenus');

        /**
         * @var Page $page
         */
        $contenu = new Contenu();
        $contenu->html = 'test';
        $contenu->save();
        $attributes['contenu_type'] = 'contenus';
        $attributes['contenu_id'] = $contenu->id;
        $page = factory(Page::class)->create($attributes);
        $page->fill($attributes);
        $page->save();

        return $contenu;
    }

    public function test_content_should_be_handled_by_his_handler()
    {
        $contenu = $this->getContenu([
            'pathname' => '/test',
        ]);

        CmsArchiServiceProvider::refreshRoutes();

        $response = $this->get('/test');

        $response->assertSuccessful();
        $response->assertJson(
            [
                'status' => true
            ]
        );
    }

    public function test_should_be_able_to_access_a_published_page()
    {
        $this->getContenu([
            'pathname' => '/test',
        ]);

        CmsArchiServiceProvider::refreshRoutes();

        $response = $this->get('/test');

        $response->assertSuccessful();
    }

}
