<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 31/07/2020
 * Time: 12:32
 */

namespace Bloom\CMS\Modules\Architecture\Http\Controllers;

use Bloom\CMS\Modules\Architecture\Model\Applicabilite;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Architecture\Model\Statut;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Routing\Controller;
use Illuminate\View\View;

/**
 * Class AdminController
 * @package Bloom\CMS\Modules\Architecture\Http\Controllers
 */
class AdminController extends Controller
{

    public function index(): View
    {
        $racine = Page::query()->whereIn('statut_id', [Statut::EN_COURS, Statut::PUBLIE])->whereNull('dossier_id')->get();
        $indexs = Page::query()->whereIn('statut_id', [Statut::EN_COURS, Statut::PUBLIE])->where('is_index', '=', 1)->whereHas('dossier', function (Builder $query) {
            return $query->whereNull('parent_id');
        })->get();

        $pages = $racine->merge($indexs);

        $applicabilites = Applicabilite::query()->whereRaw(sprintf('b_on & %d = %d', Applicabilite::ARCHI, Applicabilite::ARCHI))->get();

        return view('Archi::admin.index', compact('pages', 'applicabilites'));
    }

    public function tooglePublish(Page $page)
    {
        if ($page->statut_id == Statut::PUBLIE) {
            $page->unpublish();
        } else {
            $page->publish();
        }

        return $page;
    }

    public function unpublish(Page $page)
    {
        $page->unpublish();

        return $page;
    }

    public function publish(Page $page)
    {
        $page->publish();

        return $page;
    }

    public function delete(Page $page)
    {
        $page->softDelete();

        return $page;
    }

    public function archive(Page $page)
    {
        $page->archive();

        return $page;
    }
}