<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 02/09/2020
 * Time: 15:37
 */

namespace Bloom\CMS\Modules\Architecture\Contenus;


use Bloom\CMS\Modules\Architecture\Helpers\IsContenu;
use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class PageStatique
 * @package Bloom\CMS\Modules\Architecture\Contenus
 *
 * @property Page   page
 * @property string controller
 * @property string display_type
 */
class PageStatique extends Model implements Contenu
{
    use IsContenu;

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu)
            {
                /**
                 * @var PageStatique $contenu
                 */
                if (!preg_match('/[^@]+@[a-zA-Z_]+/', $contenu->controller)) {
                    throw new \InvalidArgumentException('"controller" invalide');
                }
                list($class, $method) = explode('@', $contenu->controller);
                if (!class_exists($class)) {
                    throw new \InvalidArgumentException("$class does not exists");
                }
                $controller = new $class(app());
                if (!method_exists($controller, $method)) {
                    throw new \InvalidArgumentException("$method does not exists in $class");
                }

                return $controller->$method($contenu->page);
            }

            public function multiple(Collection $contenus)
            {
                // Impossible
                throw new \InvalidArgumentException();
            }

            public function ensemble()
            {
                // Impossible
                throw new \InvalidArgumentException();
            }
        };
    }
}