<?php


namespace Bloom\CMS\Modules\Architecture\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Model\Dossier;
use Illuminate\Routing\Controller;

class DossierController extends Controller
{

    public function index()
    {
        $dossiers = Dossier::all();

        return view('Archi::dossier_list', compact('dossiers'));
    }

    public function edit(Dossier $dossier)
    {
        $dossiers = Dossier::all();

        return view('Archi::dossier_edit', compact('dossier', 'dossiers'));
    }

    public function save(Dossier $dossier)
    {

        $dossier->fill(request()->post());

        if (!$dossier->save()) {
            session()->flash('error', 'Une erreur est survenu lors de la sauvegarde');
        }

        return redirect()->route('admin_dossier_list');
    }

    public function delete(Dossier $dossier)
    {
        return redirect()->route('admin_dossier_list');
    }

}