<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 29/06/20
 * Time: 15:17
 */

namespace Bloom\CMS\Modules\Architecture\Database\Relation;


use Bloom\CMS\Modules\Architecture\Model\Contenu;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Database\Query\JoinClause;
use Illuminate\Support\Facades\DB;

class BelongsToPage extends Relation
{
    protected $table;
    /**
     * @var \Illuminate\Database\Eloquent\HigherOrderBuilderProxy|mixed
     */
    protected $ownerKey;
    /**
     * @var Model
     */
    protected $child;
    /**
     * @var null
     */
    protected $foreignKey;
    /**
     * @var null
     */
    protected $relationName;

    public function __construct(Builder $query, Model $child, $foreignKey = null, $ownerKey = null, $relationName = null)
    {
        $this->child = $child;
        $this->foreignKey = $foreignKey;
        $this->ownerKey = $ownerKey;
        $this->relationName = $relationName;

        parent::__construct($query, $child);
    }


    /**
     * Set the base constraints on the relation query.
     *
     * @return void
     */
    public function addConstraints()
    {
        if (static::$constraints) {
            $this->addJoinCause($this->query);
        }
    }

    protected function addJoinCause(Builder $query)
    {
        // $query = Page instance query
        // JOIN page_contenus ON pages.id = page_contenus.page_id
        $child = $this->child;
        $query->join(
            'page_contenus',
            function (JoinClause $join) use ($child) {
                $join->on('pages.id', '=', 'page_contenus.page_id');
                if ($child->getKey()) {
                    $join->on('page_contenus.contenu_id', '=', $child->getKey())
                        ->on('page_contenus.contenu_type', '=', $join->raw('"' . $child->getMorphClass() . '"'));
                }

            }
        );
    }

    public function getRelationExistenceQuery(Builder $query, Builder $parentQuery, $columns = ['*'])
    {
        $this->addJoinCause($query);

        return $query->select($columns)
            ->whereColumn('page_contenus.contenu_id', '=', $parentQuery->getModel()->qualifyColumn($parentQuery->getModel()->getKeyName()))
            ->whereColumn('page_contenus.contenu_type', '=', $parentQuery->getModel()->getMorphClass());
    }


    /**
     * Get the results of the relationship.
     *
     * @return mixed
     */
    public function getResults()
    {
        return $this->query->first();
    }

    /**
     * Gather the keys from an array of related models.
     *
     * @param array $models
     *
     * @return array
     */
    protected function getEagerModelKeys(array $models)
    {
        $keys = [];

        // First we need to gather all of the keys from the parent models so we know what
        // to query for via the eager loading query. We will add them to an array then
        // execute a "where in" statement to gather up all of those related records.
        foreach ($models as $model) {
            $link = DB::table('page_contenus')
                ->where('contenu_id', '=', $model->getKey())
                ->where('contenu_type', '=', $model->getMorphClass())->first();
            if (!is_null($link)) {
                $keys[] = $link->page_id;
            }
        }

        sort($keys);

        return array_values(array_unique($keys));
    }

    /**
     * Match the eagerly loaded results to their parents.
     *
     * @param array|Contenu[]|Model[] $models
     * @param Collection|Page[]       $results
     * @param string                  $relation
     *
     * @return array
     */
    public function match(array $models, Collection $results, $relation)
    {
        // First we will get to build a dictionary of the child models by their primary
        // key of the relationship, then we can easily match the children back onto
        // the parents using that dictionary and the primary key of the children.
        $dictionary = [];

        foreach ($results as $result) {
            $dictionary[ $result->getKey() ] = $result;
        }

        // Once we have the dictionary constructed, we can loop through all the parents
        // and match back onto their children using these keys of the dictionary and
        // the primary key of the children to map them onto the correct instances.
        foreach ($models as $model) {
            $link = DB::table('page_contenus')
                ->where('contenu_id', '=', $model->getKey())
                ->where('contenu_type', '=', $model->getMorphClass())->first();
            if ($link !== null && isset($dictionary[ $link->page_id ])) {
                $model->setRelation($relation, $dictionary[ $link->page_id ]);
            }
        }

        return $models;
    }

    /**
     * @param Page|integer $model
     *
     * @return $this
     */
    public function attach($model)
    {
        $id = $model;
        if ($model instanceof Model) {
            $id = $model->getKey();
        }
        DB::table('page_contenus')->insertOrIgnore(
            [
                'contenu_id'     => $this->child->getKey(),
                'contenu_type'   => $this->child->getMorphClass(),
                'page_id'        => $id,
                'created_at'     => now(),
                'updated_at'     => now(),
                'en_suppression' => 0,
                'en_ajout'       => 0,
                'actif'          => 1,
            ]
        );

        return $this;
    }

    public function addEagerConstraints(array $models)
    {
        // We'll grab the primary key name of the related models since it could be set to
        // a non-standard name and not "id". We will then construct the constraint for
        // our eagerly loading query so it returns the proper models from execution.
        $key = $this->related->getTable() . '.' . $this->ownerKey;

        $whereIn = $this->whereInMethod($this->related, $this->ownerKey);

        $this->query->{$whereIn}($key, $this->getEagerModelKeys($models));
    }

    public function initRelation(array $models, $relation)
    {
        foreach ($models as $model) {
            $model->setRelation($relation, null);
        }

        return $models;
    }
}