<?php

namespace Tests\Feature;

use Bloom\CMS\Modules\Architecture\Model\Dossier;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\Test;

class DossierTest extends Test
{
    public function test_should_update_pathname_of_his_pages()
    {
        /**
         * @var Page    $page
         * @var Dossier $dossier
         */
        $page = factory(Page::class)->create();
        $dossier = factory(Dossier::class)->create();

        $page->dossier()->associate($dossier);
        $page->save();

        static::assertEquals($dossier->id, $page->dossier_id);

        $dossier->slug = 'test';

        $dossier->save();

        $page->refresh();

        static::assertStringStartsWith('/test', $page->pathname);
    }

}
