<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 27/08/2020
 * Time: 11:39
 */

namespace Bloom\CMS\Modules\Architecture\Model;


use Bloom\CMS\Modules\Architecture\Helpers\IsContenu;
use Illuminate\Database\Eloquent\Model;


/**
 * Class Section
 * @package Bloom\CMS\Modules\Architecture\Model
 *
 * @property Page   $page
 * @property int    $rang
 * @property string $type
 */
class Section extends Model
{
    use IsContenu;

    public function info()
    {
        switch ($this->type) {
            case 'lien':
                return $this->hasOne(SectionLien::class);
            case 'liste':
                // no break;
            default:
                return $this->hasOne(SectionFiltre::class);
        }
    }
}