<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSectionLiens extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('section_liens', function (Blueprint $table) {
            $table->id();
            $table->string('titre');
            $table->text('description');
            $table->string('cta');
            $table->string('cta_bg');
            $table->string('cta_color');
            $table->bigInteger('section_id', false, true);
            $table->bigInteger('page_id', false, true);

            $table->foreign(['section_id'])->on('sections')->references('id')->cascadeOnDelete();
            $table->foreign(['page_id'])->on('pages')->references('id')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sections');
    }
}
