<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSectionFiltres extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('section_filtres', function (Blueprint $table) {
            $table->id();
            $table->string('titre');
            $table->bigInteger('section_id', false, true);
            $table->bigInteger('filtre_id', false, true);

            $table->foreign(['section_id'])->on('sections')->references('id')->cascadeOnDelete();
            $table->foreign(['filtre_id'])->on('filtres')->references('id')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sections');
    }
}
