import {defineConfig} from 'vite';
import laravel from 'laravel-vite-plugin';
import vue from '@vitejs/plugin-vue';

export default defineConfig({
  plugins: [
    laravel([
      'resources/js/listing.js'
    ]),
    vue({
      template: {
        transformAssetUrls: {
          base: null,
          includeAbsolute: false,
        },
      },
    }),
  ],
  build: {
    rollupOptions: {
      input: {
        listing: 'resources/js/listing.js',
        sectionInfo: 'resources/js/sectionInfo.js'
      },
      // Make sure to externalize deps that shouldn't be bundled
      // into your library
      external: ['vue'],
      output: {
        globals: {
          vue: 'Vue',
        },
        entryFileNames: (chunkInfo) => {
          // if (chunkInfo.name === 'main') {
          //   return `my-vue-lib.[format].js`;
          // } else if (chunkInfo.name === 'listing') {
          //   console.log(chunkInfo.name);
          //   return `my-vue-listing.[format].js`;
          // }
          return `[name]-[hash].[format].js`;
        },
      },
    },
  },
});