<?php


namespace Bloom\CMS\Modules\Architecture\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Contenus\Ensemble;
use Bloom\CMS\Modules\Architecture\Model\Miroir;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Architecture\Model\Redirection;
use Bloom\CMS\Modules\Architecture\Model\Section;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Tests\Unit\Contenu;

class FrontController extends Controller
{

    public function handle(Request $request)
    {
        $path = $request->getPathInfo();

        /**
         * @var Page $page
         */
        if (Page::where('pathname', '=', $path)->count() > 0) {
            $page = Page::where('pathname', '=', $path)->firstOrFail();
            $request->session()->forget('canonical_link');
        } else {
            /**
             * @var Miroir $miroir
             */
            $miroir = Miroir::where('pathname', '=', $path)->firstOrFail();
            $page = $miroir->page;
            $request->session()->put('canonical_link', $page->pathname);
            if ($miroir->dossier) {
                $dossier = $miroir->dossier;
                $fil_miroir = [['name' => $page->titre, 'url' => '']];
                while ($dossier !== null) {
                    $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
                    $dossier = $dossier->parent;
                }
                $fil_miroir = array_reverse($fil_miroir);
                view()->share('fil_miroir', $fil_miroir);
            }
        }

        $contenu = $page->contenu;
        if ($page->is_index && $page->contenu_type !== 'page_statiques') {
            $breadcrumbElements = [
                ['name' => '', 'url' => ''],
            ];
            if ($page->dossier) {
                $dossier = $page->dossier;
                while ($dossier !== null) {
                    $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
                    $dossier = $dossier->parent;
                }
            }
            $breadcrumbElements = array_reverse($breadcrumbElements);
            $sections = Section::query()->where('page_id', '=', $page->id)->orderBy('rang')->get();

            if ($sections->count() === 0) {
                // Index auto
                $pages = $page->dossier->pages()->published()->where('id', '!=', $page->id)->get();

                return view('Archi::front.index_auto', compact('page', 'breadcrumbElements', 'pages'));
            }

            $sections = Section::query()->where('page_id', '=', $page->id)->orderBy('rang')->get();

            return view('Archi::front.index_perso', compact('page', 'breadcrumbElements', 'sections'));
        }

        switch ($page->multiplicity) {
            case Page::SINGLE:
                return $page->contenu->getHandler()->single($page->contenu);
            case Page::ALL:
                /**
                 * @var Ensemble $ensemble
                 */
                $ensemble = $page->contenu;
                $model = $ensemble->type;
                /**
                 * @var Contenu $contenu
                 */
                $contenu = new $model();

                return $contenu->getHandler()->ensemble();
            case Page::MUTLI:
                break;
        }

        return abort(404);
    }

    public function redirect(Request $request)
    {
        $path = $request->getPathInfo();

        $redirection = Redirection::published()->where('source', '=', $path)->first();
        $hard = $redirection->hard;
        while ($r = Redirection::published()->where('source', '=', $redirection->cible)->first()) {
            $hard = $hard || $r->hard;
            $redirection = $r;
        }

        return redirect($redirection->cible, $hard ? Response::HTTP_MOVED_PERMANENTLY : Response::HTTP_FOUND);
    }
}