<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 31/07/2020
 * Time: 12:32
 */

namespace Bloom\CMS\Modules\Architecture\Http\Controllers;

use Bloom\CMS\Modules\Architecture\Model\Applicabilite;
use Bloom\CMS\Modules\Architecture\Model\Dossier;
use Bloom\CMS\Modules\Architecture\Model\Miroir;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Architecture\Model\Statut;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

/**
 * Class AdminController
 * @package Bloom\CMS\Modules\Architecture\Http\Controllers
 */
class AdminController extends Controller
{

    public function index(): View
    {
        $racine = Page::query()->whereIn('statut_id', [Statut::EN_COURS, Statut::PUBLIE])->whereNull('dossier_id')->get();
        $indexs = Page::query()->whereIn('statut_id', [Statut::EN_COURS, Statut::PUBLIE])->where('is_index', '=', 1)->whereHas('dossier', function (Builder $query) {
            return $query->whereNull('parent_id');
        })->get();
        $miroirs = Miroir::query()->whereIn('statut_id', [Statut::EN_COURS, Statut::PUBLIE])->whereNull('dossier_id')->get();

        $pages = $racine->merge($indexs)->concat($miroirs);

        $applicabilites = Applicabilite::query()->whereRaw(sprintf('b_on & %d = %d', Applicabilite::ARCHI, Applicabilite::ARCHI))->get();

        return view('Archi::admin.index', compact('pages', 'applicabilites'));
    }

    public function tooglePublish(Page $page)
    {
        if ($page->statut_id == Statut::PUBLIE) {
            $page->unpublish();
        } else {
            $page->publish();
        }

        return redirect()->route('admin_archi_index');
    }

    public function unpublish(Page $page)
    {
        $page->unpublish();

        return redirect()->route('admin_archi_index');
    }

    public function publish(Page $page)
    {
        $page->publish();

        return redirect()->route('admin_archi_index');
    }

    public function delete(Page $page)
    {
        $page->softDelete();

        return redirect()->route('admin_archi_index');
    }

    public function archive(Page $page)
    {
        $page->archive();

        return redirect()->route('admin_archi_index');
    }

    public function move(Page $page)
    {
        if (!$page->is_index) {
            $page->dossier_id = request('dossier_id');
        } else {
            $page->dossier->parent_id = request('dossier_id');
            $page->dossier->save();
        }
        $page->save();

        return redirect()->route('admin_archi_index');
    }

    public function getFormMove(Page $page)
    {
        $dossiers = Page::query()
            ->where("is_index", '=', 1)
            ->whereIn('statut_id', [Statut::PUBLIE, Statut::EN_COURS])->get()->map(function (Page $page) {
                return $page->dossier;
            })->filter(function (Dossier $dossier) use ($page) {
                if ($page->is_index) {
                    return $dossier->nb_parents < 2;
                }

                return true;
            });

        return \view('Archi::admin.form_move', compact('page', 'dossiers'));
    }

    //Section Miroir
    public function miroir(Page $page)
    {
        $page_miroir = new Miroir();
        $page_miroir->page()->associate($page);
        $page_miroir->dossier_id = request('dossier_id');
        $page_miroir->cree_par()->associate(Auth::user());
        $page_miroir->derniere_modification_par()->associate(Auth::user());
        $page_miroir->statut_id = $page->statut_id;
        $page_miroir->pathname = request('pathname-miroir');
        $page_miroir->save();

        return redirect()->route('admin_archi_index');
    }

    public function getFormMiroir(Page $page)
    {
        $dossiers = Page::query()
            ->where("is_index", '=', 1)
            ->whereIn('statut_id', [Statut::PUBLIE, Statut::EN_COURS])->get()->map(function (Page $page) {
                return $page->dossier;
            })->filter(function (Dossier $dossier) use ($page) {
                if ($page->is_index) {
                    return $dossier->nb_parents < 2;
                }

                return true;
            });

        return  \view('Archi::admin.form_miroir', compact('page', 'dossiers'));
    }

    public function unpublishMiroir(Miroir $miroir)
    {
        $miroir->unpublish();

        return redirect()->route('admin_archi_index');
    }

    public function publishMiroir(Miroir $miroir)
    {
        $miroir->publish();

        return redirect()->route('admin_archi_index');
    }

    public function deleteMiroir(Miroir $miroir)
    {
        $miroir->softDelete();

        return redirect()->route('admin_archi_index');
    }

    public function archiveMiroir(Miroir $miroir)
    {
        $miroir->archive();

        return redirect()->route('admin_archi_index');
    }

}