<?php

namespace Tests\Feature;

use Bloom\CMS\Modules\Architecture\CmsArchiServiceProvider;
use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphToMany;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Tests\Test;

class PageTest extends Test
{

    use DatabaseMigrations, RefreshDatabase;

    public function getContenu(array $attributes = []): Contenu
    {
        Relation::morphMap([
            'contenus' => Contenu::class,
        ]);

        Page::declareContenu('contenus');

        /**
         * @var Page $page
         */
        $page = factory(Page::class)->create($attributes);

        return $page->contenus()->create(
            ['html' => 'test']
        );
    }

    public function test_content_should_be_handled_by_his_handler()
    {
        $contenu = $this->getContenu([
            'pathname' => '/test',
        ]);

        CmsArchiServiceProvider::refreshRoutes();

        $response = $this->get('/test');

        $response->assertSuccessful();
        $response->assertJson(
            [
                'status' => true
            ]
        );
    }

    public function test_should_be_able_to_access_a_published_page()
    {
        $this->getContenu([
            'pathname' => '/test',
        ]);

        CmsArchiServiceProvider::refreshRoutes();

        $response = $this->get('/test');

        $response->assertSuccessful();
    }

}
