<?php

namespace Tests\Feature;

use Bloom\CMS\Modules\Architecture\Model\Dossier;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Auth;
use Tests\Test;

class AdminTest extends Test
{
    use DatabaseMigrations, RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        // On met un utilisateur vide pour nos test
        Auth::setUser(new class implements Authenticatable {

            /**
             * @inheritDoc
             */
            public function getAuthIdentifierName()
            {
                // TODO: Implement getAuthIdentifierName() method.
            }

            /**
             * @inheritDoc
             */
            public function getAuthIdentifier()
            {
                // TODO: Implement getAuthIdentifier() method.
            }

            /**
             * @inheritDoc
             */
            public function getAuthPassword()
            {
                // TODO: Implement getAuthPassword() method.
            }

            /**
             * @inheritDoc
             */
            public function getRememberToken()
            {
                // TODO: Implement getRememberToken() method.
            }

            /**
             * @inheritDoc
             */
            public function setRememberToken($value)
            {
                // TODO: Implement setRememberToken() method.
            }

            /**
             * @inheritDoc
             */
            public function getRememberTokenName()
            {
                // TODO: Implement getRememberTokenName() method.
            }
        });
    }


    public function test_dossier_list_should_show_all_dossier()
    {
        $response = $this->get(route('admin_dossier_list'));

        $response->assertSuccessful();

        $response->assertViewIs('Archi::dossier_list');
        $response->assertViewHas(['dossiers']);
    }

    public function test_dossier_edit_should_load_all_other_dossier()
    {
        factory(Dossier::class, 3)->create();
        $response = $this->get(route('admin_dossier_edit'));

        $response->assertSuccessful();
        $response->assertViewIs('Archi::dossier_edit');
        /**
         * @var Dossier[]|Collection $dossiers
         */
        $dossiers = $response->viewData('dossiers');

        static::assertEquals(3, $dossiers->count());
    }

    public function test_post_save_should_create_dossier()
    {

        $post = [
            'name'      => 'Dossier',
            'slug'      => 'dossier',
            'parent_id' => null,
            'type'      => 'simple'
        ];

        $response = $this->post(route('admin_dossier_save'), $post);

        $response->assertRedirect(route('admin_dossier_list'));
        static::assertDatabaseHas('dossiers', $post);
        $response->assertSessionMissing('error');

    }

    public function test_edit_should_show_dossier_info()
    {
        /**
         * @var Dossier $dossier
         */
        $dossier = factory(Dossier::class)->create();

        $response = $this->get(route('admin_dossier_edit', $dossier));
        $response->assertSuccessful();
        $response->assertViewHas('dossier');

        static::assertEquals($dossier->id, $response->viewData('dossier')->id);
        libxml_use_internal_errors(true);
        $content = new \DOMDocument();
        $content->loadHTML($response->content());
        libxml_use_internal_errors(false);

        $inputs = $content->getElementsByTagName('input');
        for ($i = 0; $i < $inputs->count(); $i++) {
            $input = $inputs->item($i);
            $name = (string)$input->attributes->getNamedItem('name')->nodeValue;
            if (in_array($name, ['name', 'slug'])) {
                static::assertEquals($dossier->{$name}, (string)$input->attributes->getNamedItem('value')->nodeValue);
            }
        }
        $selects = $content->getElementsByTagName('select');

        for ($i = 0; $i < $selects->count(); $i++) {
            $input = $inputs->item($i);
            $name = (string)$input->attributes->getNamedItem('name')->nodeValue;
            if (in_array($name, ['parent_id', 'type'])) {
                static::assertEquals((string)$dossier->{$name}, (string)$input->attributes->getNamedItem('value')->nodeValue);
            }
        }
    }

}
