<?php


namespace Bloom\CMS\Modules\Architecture\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Model\Contenu;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Response;
use Illuminate\View\View;

interface ContenuHandler
{

    /**
     * Prend en charge l'affichage d'un contenu simple
     *
     * @param Contenu $contenu
     *
     * @return Response
     */
    public function single(Contenu $contenu): Response;

    /**
     * Prend en charge l'affichage multiple
     * @param Collection $contenus
     *
     * @return Response
     */
    public function multiple(Collection $contenus): Response;

    /**
     * Prend en charge l'affichage d'un ensemble
     *
     * @return mixed
     */
    public function ensemble();

    /**
     * Retourne le formulaire du contenu
     *
     * @param Contenu|null $contenu
     *
     * @return View
     */
    public function adminForm(Contenu $contenu = null): View;

    /**
     * Est appelé lors de la sauvegarde de la page
     *
     * @param Contenu|Model $contenu
     * @param array   $attributes
     *
     * @return bool
     */
    public function save(Contenu $contenu, array $attributes): bool;
}