<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPagessTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pages', function (Blueprint $table) {
            $table->id();
            $table->string('titre');
            $table->string('meta_titre');
            $table->string('meta_description');
            $table->string('slug')->nullable();
            $table->string('pathname');
            $table->text('intro')->nullable();
            $table->string('multiplicity');

            $table->dateTime('to_publish_at')->nullable();
            $table->dateTime('to_unpublish_at')->nullable();

            $table->integer('statut_id', false, true);
            $table->integer('dossier_id', false, true)->nullable();
            $table->integer('created_by', false, true)->default(1);
            $table->integer('last_modified_by', false, true)->default(1);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pages');
    }
}
