<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateForm extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('forms', function (Blueprint $table) {
            $table->id();
            $table->string('titre');
            $table->string('view');
            $table->integer('module_id', false, true);

            $table->foreign('module_id')->on('modules')->references('id')->cascadeOnDelete();
        });

        Schema::table('menus', function (Blueprint $table) {
            $table->integer('form_id');
            $table->foreign('form_id')->on('forms')->references('id')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('menus', function (Blueprint $table) {
            $table->dropForeign(['form_id']);
            $table->dropColumn('form_id');
        });
        Schema::dropIfExists('forms');
    }
}
