<?php


namespace Bloom\CMS\Modules\Architecture\Model;


use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;

/**
 * Class Module
 * @package Bloom\CMS\Modules\Architecture\Model
 *
 * @property string                 $nom
 * @property string                 $nom_public
 * @property string                 $route
 * @property AdminMenu[]|Collection $subMenus
 * @property boolean                $active
 *
 * @method static Builder nom(string $nom)
 * @method static Builder actif()
 */
class Module extends Model
{
    protected $guarded = [];

    public function scopeNom(Builder $query, string $nom)
    {
        return $query->where('nom', '=', $nom);
    }

    public function scopeActif(Builder $query)
    {
        return $query->where('active', '=', 1);
    }

    public function subMenus()
    {
        return $this->hasMany(AdminMenu::class);
    }
}
