<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 03/08/2020
 * Time: 11:38
 */

namespace Bloom\CMS\Modules\Architecture\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Model\Dossier;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Routing\Controller;

class SommaireAutoController extends Controller
{
    public function edit(Page $page)
    {
        return \view('Archi::admin.form_auto', compact('page'));
    }

    public function save(Page $page)
    {
        // Sauvegarde des index automatique
        if ($page->exists) {
            // Edition
        } else {
            // Création
            $page->intro = request('intro');
            $page->titre = request('titre');
            $page->meta_titre = request('titre');
            $page->meta_description = '';
            $page->slug = '';
            $page->multiplicity = Page::SINGLE;
            $page->statut_id = request('statut_id', 2);
            $page->image_opengraph = request('image_opengraph');

            $dossier = new Dossier(['name' => $page->titre, 'slug' => request('slug'), 'type' => '']);
            $dossier->save();
            $page->dossier()->associate($dossier);
            $page->is_index = true;
        }
        $page->save();
    }
}