<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 29/06/20
 * Time: 15:17
 */

namespace Bloom\CMS\Modules\Architecture\Database\Relation;


use Bloom\CMS\Modules\Architecture\Model\Contenu;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Query\JoinClause;
use Illuminate\Support\Facades\DB;

class BelongsToPage extends BelongsTo
{
    protected $table;

    public function __construct(Builder $query, Model $child, $foreignKey = null, $ownerKey = null, $relationName = null)
    {
        parent::__construct($query, $child, $foreignKey, $ownerKey, $relationName);
    }


    /**
     * Set the base constraints on the relation query.
     *
     * @return void
     */
    public function addConstraints()
    {
        if (static::$constraints) {
            // $query = Page instance query
            // JOIN page_contenus ON pages.id = page_contenus.page_id
            $child = $this->child;
            $this->query->join(
                'page_contenus',
                function (JoinClause $join) use ($child) {
                    $join->on('pages.id', '=', 'page_contenus.page_id')
                        ->on('page_contenus.contenu_id', '=', $child->getKey())
                        ->on('page_contenus.contenu_type', '=', $join->raw('"' . $child->getMorphClass() . '"'));
                }
            );
        }
    }

    /**
     * Get the results of the relationship.
     *
     * @return mixed
     */
    public function getResults()
    {
        return $this->query->first() ?: $this->getDefaultFor($this->parent);
    }

    /**
     * Gather the keys from an array of related models.
     *
     * @param array $models
     *
     * @return array
     */
    protected function getEagerModelKeys(array $models)
    {
        $keys = [];

        // First we need to gather all of the keys from the parent models so we know what
        // to query for via the eager loading query. We will add them to an array then
        // execute a "where in" statement to gather up all of those related records.
        foreach ($models as $model) {
            $link = DB::table('page_contenus')
                ->where('contenu_id', '=', $model->getKey())
                ->where('contenu_type', '=', $model->getMorphClass())->first();
            if (!is_null($link)) {
                $keys[] = $link->page_id;
            }
        }

        sort($keys);

        return array_values(array_unique($keys));
    }

    /**
     * Match the eagerly loaded results to their parents.
     *
     * @param array|Contenu[]|Model[] $models
     * @param Collection|Page[]       $results
     * @param string                  $relation
     *
     * @return array
     */
    public function match(array $models, Collection $results, $relation)
    {
        // First we will get to build a dictionary of the child models by their primary
        // key of the relationship, then we can easily match the children back onto
        // the parents using that dictionary and the primary key of the children.
        $dictionary = [];

        foreach ($results as $result) {
            $dictionary[ $result->getKey() ] = $result;
        }

        // Once we have the dictionary constructed, we can loop through all the parents
        // and match back onto their children using these keys of the dictionary and
        // the primary key of the children to map them onto the correct instances.
        foreach ($models as $model) {
            $link = DB::table('page_contenus')
                ->where('contenu_id', '=', $model->getKey())
                ->where('contenu_type', '=', $model->getMorphClass())->first();
            if ($link !== null && isset($dictionary[ $link->page_id ])) {
                $model->setRelation($relation, $dictionary[ $link->page_id ]);
            }
        }

        return $models;
    }
}