<?php


namespace Bloom\CMS\Modules\Architecture\Contenus;


use Bloom\CMS\Modules\Architecture\Helpers\IsContenu;
use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Http\Response;

/**
 * Class Filtre
 * @package Bloom\CMS\Modules\Architecture\Contenus
 *
 * @property string   model
 * @property string[] scopes
 * @property string[] args
 */
class Filtre extends Model implements Contenu
{
    use IsContenu;

    protected $casts = [
        'scopes' => 'array',
        'args'   => 'array'
    ];

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu): Response
            {
                return \response();
            }

            public function multiple(Collection $contenus): Response
            {
                return \response();
            }

            public function ensemble()
            {
                return \response();
            }
        };
    }

    public function execute()
    {
        /*
         * ***************************
         * * Exemple de valorisation *
         * ***************************
         *
         * Model  : "Voiture",
         * Scopes : "marque,motorisation",
         * Args   : "[ [ 'Honda' ], ['essence','1.2'] ]"
         */
        /**
         * @var Model $model
         */
        $model = $this->model;
        if (!is_subclass_of($model, Model::class)) {
            $model = Relation::getMorphedModel($model);
        }
        $query = $model::query();
        foreach ($this->scopes as $k => $scope) {
            $query->scopes([
                $scope => $this->args[ $k ]
            ]);
        }

        return $query->get();
    }
}