import SectionInfo from './vue/SectionInfo.vue';
import Section from './components/Section';

const slugify = require('slugify');
const Vue = require('vue');

let loaded = false;
document.addEventListener("readystatechange", () => {
    function listenForm() {
        function bindSection(rang, section) {
            $('[name="section' + rang + '-type"]').change(function (e) {
                let regex;
                if (e.target.value === 'liste') {
                    regex = new RegExp('^section' + rang + '-lien');
                } else {
                    regex = new RegExp('^section' + rang + '-liste');
                }
                section.find('input,select,textarea').each(function () {
                    this.disabled = this.name.match(regex);
                    if (this.dataset.toggle === 'ckeditor' && window.CKEDITOR !== undefined && window.CKEDITOR.instances.hasOwnProperty(this.name)) {
                        window.CKEDITOR.instances[this.name].setReadOnly(this.disabled);
                    }
                    if (this.classList.contains('color-picker') && this.disabled) {
                        $('[for="' + this.id + '"].control-label').parent().addClass('disabled');
                    } else {
                        $('[for="' + this.id + '"].control-label').parent().removeClass('disabled');
                    }
                });
            });
        }

        if ($('.modal #form').hasClass('sections')) {
            // $('.modal section').each(function (key) {
            //     bindSection(key + 1, $(this));
            // });
            new Vue({
                el: '.modal #form',
                components: {
                    'section-info': SectionInfo
                },
                data() {
                    return {
                        sections: window.Sections
                    }
                },
                computed: {},
                methods: {
                    sortSections: function () {
                        this.sections.sort((a, b) => {
                            if (a.rang < b.rang) return -1;
                            if (a.rang > b.rang) return 1;
                            return 0;
                        });
                    },
                    addSection() {
                        this.sections.push(new Section(this.sections.length + 1));
                    },
                    rankUp(form) {
                        let index = this.sections.indexOf(form);
                        this.sections[index - 1].rang++;
                        form.rang--;
                        this.sortSections();
                    },
                    rankDown(form) {
                        let index = this.sections.indexOf(form);
                        this.sections[index + 1].rang--;
                        form.rang++;
                        this.sortSections();
                    }
                },
                mounted() {
                    window.bindCkfinder();
                }
            })
        }
    }

    if (!loaded) {
        loaded = true;
        $('.choix-sommaire a').click(function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            let el = $(this), route = el.data('toload'), titleModal = el.data('title');
            axios.get(route).then((response) => {
                $('#whatEverModalLabel').text(titleModal);
                $('.modal-body').html(response.data)
                $('.modal').modal();
                listenForm();
            });
        });

        $(document).on('edit-sommaire', function (e) {
            axios.get(e.detail.route).then((response) => {
                $('.modal-body').html(response.data)
                $('.modal').modal();
                listenForm();
            });
        })

        $('.modal').delegate('#titre', 'input', function (e) {
            $('#slug').val(slugify(e.target.value, {
                strict: true,
                remove: /\s[!.?]/g
            }));
        });
    }
});