<?php


namespace Bloom\CMS\Modules\Architecture\Model;


use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

/**
 * Class Dossier
 * @package Bloom\CMS\Modules\Architecture\Model
 *
 * @property string               $name
 * @property string               $slug
 * @property string               $type
 *
 * @property string               $full_pathname
 *
 * @property Dossier              $parent
 * @property Dossier[]|Collection $childs
 * @property Page[]|Collection    $pages
 */
class Dossier extends Model
{

    protected $guarded = [];

    protected static function booted()
    {
        static::updated(function (Dossier $dossier) {
            if ($dossier->isDirty(['slug', 'parent_id'])) {
                foreach ($dossier->pages as $page) {
                    $page->pathname = '/' . $page->dossier->full_pathname . '/' . $page->slug;
                    $page->save();
                }
            }
        });
    }

    public function parent()
    {
        return $this->belongsTo(Dossier::class, 'parent_id');
    }

    public function childs()
    {
        return $this->hasMany(Dossier::class, 'parent_id');
    }

    public function pages()
    {
        return $this->hasMany(Page::class);
    }

    public function setSlugAttribute(string $slug)
    {
        $this->attributes['slug'] = Str::slug(str_replace('/', '', $slug));
    }

    public function getFullPathnameAttribute()
    {
        $slugs = [$this->slug];
        $parent = $this->parent;
        while ($parent !== null) {
            $slugs[] = $parent->slug;
            $parent = $parent->parent;
        }

        return implode('/', array_reverse($slugs));
    }

}