<?php


namespace Bloom\CMS\Modules\Architecture\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Contenus\Ensemble;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Tests\Unit\Contenu;

class FrontController extends Controller
{

    public function handle(Request $request)
    {
        $path = $request->getPathInfo();

        /**
         * @var Page $page
         */
        $page = Page::where('pathname', '=', $path)->firstOrFail();

        switch ($page->multiplicity) {
            case Page::SINGLE:
                return $page->contenu->getHandler()->single($page->contenu);
            case Page::ALL:
                /**
                 * @var Ensemble $ensemble
                 */
                $ensemble = $page->contenu;
                $model = $ensemble->type;
                /**
                 * @var Contenu $contenu
                 */
                $contenu = new $model();
                return $contenu->getHandler()->ensemble();
            case Page::MUTLI:
                break;
        }

        return abort(404);
    }
}