<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 13/07/20
 * Time: 12:15
 */

namespace Bloom\CMS\Modules\Architecture\Model;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Lien
 * @package Bloom\CMS\Modules\Architecture\Model
 *
 * @property string href
 * @property Page   page
 *
 * @property string url
 */
class Lien extends Model
{

    public function page()
    {
        return $this->belongsTo(Page::class);
    }

    public function getUrlAttribute()
    {
        return $this->href ?: $this->page !== null ? $this->page->pathname : '#';
    }
}