<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 31/07/2020
 * Time: 12:22
 */

use Illuminate\Support\Facades\Route;

Route::group([
    'prefix'     => config('app.admin') . '/architecture',
    'middleware' => ['auth'],
    'namespace'  => 'Bloom\CMS\Modules\Architecture\Http\Controllers'
], function () {
    Route::get('/', 'AdminController@index')->name('admin_archi_index');
    Route::get('/{page}/publish', 'AdminController@publish')->name('admin_archi_publish');
    Route::get('/{page}/unpublish', 'AdminController@unpublish')->name('admin_archi_unpublish');
    Route::get('/{page}/archive', 'AdminController@archive')->name('admin_archi_archive');
    Route::get('/{page}/delete', 'AdminController@delete')->name('admin_archi_delete');
    Route::post('/dir/auto/{page?}', 'SommaireController@saveAuto')->name('admin_archi_auto_save');
    Route::post('/dir/perso/{page?}', 'SommaireController@savePerso')->name('admin_archi_perso_save');
    Route::get('/dir/{type}/{page?}', 'SommaireController@form')->name('admin_archi_som');
});
