<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 03/08/2020
 * Time: 11:38
 */

namespace Bloom\CMS\Modules\Architecture\Http\Controllers;

use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Core\Http\Indexes\Section;
use Bloom\CMS\Core\Http\Indexes\SectionDossier;
use Bloom\CMS\Core\Http\Indexes\SectionLien;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Modules\Architecture\Model\Node;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Ramsey\Uuid\Uuid;

class SommaireController extends Controller
{
    public function form(string $type, Page $page)
    {
        $data = compact('page');
        $data['parent_id'] = request('parent_id');
        if ($type === 'perso') {
            // On charge la liste des dossiers
            $data['dossiers'] = Page::query()
                ->where("is_index", '=', 1)
                ->whereIn('statut_id', [Statut::PUBLIE, Statut::EN_COURS])->get()->map(function (Page $page) {
                    return $page->dossier;
                });
            $data['pages'] = Page::published()->where('id', '!=', $page->id)->get();
            $data['sections'] = Section::query()->where('page_id', '=', $page->id)->get();
            if ($data['sections']->count() === 0) {
                $section = new Section();
                $section->rang = 1;
                $section->type = 'liste';
                $section->id = Uuid::uuid4()->toString();
                $section->titre = 'Section 1';
                $data['sections'][] = $section;
            } else {
                $data['sections']->each(function ($section) {
                    //On lazy laod l'info
                    $section->info;
                });
            }
            $data['selectPages'] = $this->getPages();
        }

        return \view('Archi::admin.form_' . $type, $data);
    }

    public function buildPage(Page $page, Miroir $pageDossier = null): Node
    {
        $node = new Node();
        if ($pageDossier) {
            $node->id = $pageDossier->id;
            $node->type = "miroir";
        } else {
            $node->id = $page->id;
            $node->type = "pages";
        }
        $node->title = $page->titre;
        return $node;
    }

    public function buildTree(Dossier $dossier): Node
    {
        $node = new Node();
        $node->type = "pages";

        $pages = $dossier->pages()
            ->where('statut_id', '=', Statut::PUBLIE)
            ->get();
        foreach ($pages as $page) {
            if ($page->is_index) {
                $node->title = $page->titre;
                $node->id = $page->id;
            } else {
                $node->children[] = $this->buildPage($page, null);
            }
        }

        $children = $dossier->childs;
        foreach ($children as $child) {
            $node->children[] = $this->buildTree($child);
        }

        $pagesDossiers = $dossier->miroirs()->where('statut_id', '=', Statut::PUBLIE)->get();
        foreach ($pagesDossiers as $pagesDossier) {
            $page = Page::published()
                ->where('id', '=', $pagesDossier->page_id)
                ->first();
            if ((int)$pagesDossier->page->statut_id == Statut::PUBLIE) {
                $node->children[] = $this->buildPage($page, $pagesDossier);
            }
        }

        return $node;
    }


    /**
     * @param array|Node[] $children
     * @param int $level
     * @return \Illuminate\Support\Collection
     */
    public function getTabWithTree(array $children, int $level): \Illuminate\Support\Collection
    {
        $tab = collect();

        foreach ($children as $child) {
            $child->level = $level;
            $tab[] = $child->toArray();
            if (!empty($child->children)) {
                $tab = $tab->concat($this->getTabWithTree($child->children, $level + 1));
            }
        }
        return $tab;
    }

    public function getPages()
    {
        $node = new Node();

        $pages = Page::published()->whereNull('dossier_id')->get();
        $dossiers = Dossier::query()->whereNull('parent_id')->get();

        foreach ($pages as $page) {
            $node->children[] = $this->buildPage($page, null);
        }
        foreach ($dossiers as $dossier) {
            $node->children[] = $this->buildTree($dossier);
        }

        $tab = $this->getTabWithTree($node->children, 0);

        return json_encode($tab);
    }


    protected function fillPage(Page $page)
    {
        $page->deriere_modification_par()->associate(Auth::user());
        $page->intro = request('intro');
        $page->titre = request('titre');
        $page->meta_titre = request('titre');
        $page->meta_description = '';
        $page->slug = '';
        $page->multiplicity = Page::SINGLE;
        $page->statut_id = request('statut_id', 2);
        $page->image_opengraph = request('vignette');
        $page->mentions = request('mentions');
        if ($page->exists) {
            // Edition
            $dossier = $page->dossier;
            $dossier->name = $page->titre;
            $dossier->slug = request('slug');
            $dossier->save();
        } else {
            $page->cree_par()->associate(Auth::user());
            // Création
            $dossier = new Dossier(['name' => $page->titre, 'slug' => request('slug'), 'type' => '']);
            if (request('parent_id')) {
                /**
                 * @var Page $parent
                 */
                $parent = Page::find(request('parent_id'));
                if ($parent) {
                    $dossier->parent_id = $parent->dossier_id;
                }
            }
            $dossier->save();
            $page->dossier()->associate($dossier);
            $page->is_index = true;
        }
    }

    public function saveAuto(Page $page)
    {
        // Sauvegarde des index automatique
        $this->fillPage($page);
        $page->save();


        return redirect()->route('admin_archi_index');
    }

    public function savePerso(Page $page)
    {
        Log::debug("sauvegade d'un nouveau dossier perso", ['request' => request()->all()]);
        // Sauvegarde des index automatique
        $this->fillPage($page);
        try {
            DB::transaction(
                function () use ($page) {
                    $page->save();
                    foreach (Section::query()->where('page_id', '=', $page->id)->get() as $section) {
                        /**
                         * @var Section $section
                         */
                        if ($section->info) {
                            // Si la section existe
                            $section->info->delete();
                        }
                    }

                    $k = 1;
                    while (request('rang-' . $k)) {
                        /**
                         * @var string|null $prefix
                         */
                        $prefix = request('rang-' . $k);
                        $section = Section::find(str_replace('section', '', request('rang-' . $k)));
                        if ($section === null) {
                            $section = new Section();
                            $section->page_id = $page->id;
                        }
                        $section->rang = $k;
                        $section->type = request($prefix . '-type');
                        $section->titre = request($prefix . '-' . $section->type . '-titre');
                        $section->save();
                        switch ($section->type) {
                            case 'lien':
                                $prefix .= '-lien';
                                $sub = new SectionLien();
                                $sub->description = request($prefix . '-description');
                                $sub->cta = request($prefix . '-cta');
                                $sub->cta_bg = request($prefix . '-cta_bg');
                                $sub->cta_color = request($prefix . '-cta_color');
                                $page_id = request($prefix . '-page');
                                $type = 'pages';
                                if ($page_id !== null) {
                                    list($page_id, $type) = explode(';', $page_id);
                                }
                                if ($type === 'pages') {
                                    $sub->page_id = $page_id;
                                    $sub->miroir_id = null;
                                } else {
                                    $sub->miroir_id = $page_id;
                                    $sub->page_id = null;
                                }
                                $sub->section_id = $section->id;
                                break;
                            case 'liste':
                                // no break;
                            default:
                                $prefix .= '-liste';
                                $sub = new SectionDossier();
                                $sub->dossier_id = request($prefix . '-dossier');
                                $sub->section_id = $section->id;
                                break;
                        }
                        $sub->save();

                        // increments
                        $k++;
                    }
                    $page->touch();
                }
            );
        } catch (\Throwable $e) {
            Log::error($e->getMessage(), ['error' => $e]);
            session()->flash('error', 'Une erreur est survenue lors de la sauvagarde');
        }

        return redirect()->route('admin_archi_index');
    }
}
