<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 03/12/2020
 * Time: 16:02
 */

namespace Tests\Feature;


use Bloom\Cms\Configuration\CmsConfigurationProvider;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Miroir;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Architecture\CmsArchiServiceProvider;
use Faker\Factory;
use Illuminate\Foundation\Auth\User;
use Illuminate\Support\Facades\DB;

class SommaireTest extends \Bloom\CMS\Core\Test
{
    protected $provider = CmsArchiServiceProvider::class;
    protected $packages = [CmsConfigurationProvider::class];

    public function test_index_should_load_page_and_miror()
    {
        // Pour une certaine raison dans le pipeline la tables est pas correctement vidé entre cet class de test
        // Et la classe d'avant
        DB::connection()->statement('SET FOREIGN_KEY_CHECKS=0');
        Miroir::query()->truncate();
        Page::query()->truncate();
        DB::connection()->statement('SET FOREIGN_KEY_CHECKS=1');
        $dossier = factory(Dossier::class)->create();
        $page = factory(Page::class)
            ->state('index')
            ->create(['dossier_id' => $dossier->id, 'pathname' => '/' . $dossier->slug]);
        $miroir = new Miroir();
        $miroir->page()->associate($page);
        $miroir->statut_id = 1;
        $miroir->cree_par()->associate(User::first());
        $miroir->deriere_modification_par()->associate(User::first());
        $miroir->save();

        $response = $this->actingAs(User::first())->get(route('admin_archi_index', $page));
        $response->assertOk();
        $response->assertViewIs('Archi::admin.index');
        $pages = $response->viewData('pages');
        static::assertEquals(2, $pages->count());
    }

    public function test_get_form_should_load_correct_view()
    {
        foreach (['auto', 'perso'] as $type) {
            $response = $this->actingAs(User::first())->get(route('admin_archi_som', compact('type')));
            $response->assertOk();
            $response->assertViewIs('Archi::admin.form_' . $type);
        }
    }

    public function test_form_perso_should_load_with_a_fake_section()
    {
        $response = $this->actingAs(User::first())->get(route('admin_archi_som', ['type' => 'perso']));
        $response->assertOk();
        $response->assertViewIs('Archi::admin.form_perso');
        $sections = $response->viewData('sections');
        static::assertEquals(1, $sections->count());
    }

    public function test_form_auto_should_create_a_dir_with_the_index()
    {
        $form = [
            'intro'    => 'Test',
            'titre'    => 'Test',
            'vignette' => 'vignette.jpg',
            'slug'     => 'test',
        ];

        $expect = [
            'intro'           => 'Test',
            'titre'           => 'Test',
            'image_opengraph' => 'vignette.jpg',
            'slug'            => '',
            'pathname'        => '/test'
        ];

        $response = $this->actingAs(User::first())->post(route('admin_archi_auto_save'), $form);
        $response->assertRedirect();

        $form['slug'] = '';
        $this->assertDatabaseHas('pages', $expect);
        $this->assertDatabaseHas('dossiers', ['slug' => 'test']);
    }


    public function test_form_perso_should_save_the_section_correctly()
    {
        $d = factory(Dossier::class)->create();
        $p = factory(Page::class)->create();
        $faker = Factory::create();
        $form = [
            'intro'                      => 'Test',
            'titre'                      => 'Test',
            'vignette'                   => 'vignette.jpg',
            'slug'                       => 'test',
            'rang-1'                     => 'section1',
            'section1-lien-titre'        => 'Section 1 lien',
            'section1-lien-description'  => 'Section 1',
            'section1-type'              => 'lien',
            'section1-lien-cta_color'    => $faker->hexColor,
            'section1-lien-cta'          => 'CTA',
            'section1-lien-cta_bg'       => $faker->hexColor,
            'section1-lien-page'         => $p->id . ';pages',
            'rang-2'                     => 'section2',
            'section2-liste-description' => 'Section 2',
            'section2-liste-titre'       => 'Section 2 dossier',
            'section2-type'              => 'liste',
            'section2-liste-dossier'     => $d->id,
        ];

        $expected = [
            'intro'           => 'Test',
            'titre'           => 'Test',
            'image_opengraph' => 'vignette.jpg',
            'slug'            => '',
            'pathname'        => '/test'
        ];

        $response = $this->actingAs(User::first())->post(route('admin_archi_perso_save'), $form);
        $response->assertRedirect();

        $this->assertDatabaseHas('pages', $expected);
        $this->assertDatabaseHas('dossiers', ['slug' => 'test']);
        $this->assertDatabaseCount('sections', 2);
        $this->assertDatabaseCount('section_liens', 1);
        $this->assertDatabaseCount('section_dossiers', 1);
    }
}
