<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 27/08/2020
 * Time: 11:39
 */

namespace Bloom\CMS\Modules\Architecture\Model;


use Illuminate\Database\Eloquent\Model;


/**
 * Class Section
 * @package Bloom\CMS\Modules\Architecture\Model
 *
 * @property Section parent
 *
 * @property Dossier dossier
 */
class SectionDossier extends Model
{
    public function parent()
    {
        return $this->belongsTo(Section::class);
    }

    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }

    public function getPagesAttribute()
    {
        // On veux que les pages publié
        return $this->dossier->pages()->published()->get();
    }
}