<?php

namespace Tests\Unit;

use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphToMany;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Illuminate\View\View;
use Tests\Test;


/**
 * Class Contenu
 * @package Tests\Unit
 *
 * @property Page $page
 */
class Contenu extends Model implements \Bloom\CMS\Modules\Architecture\Model\Contenu
{
    protected $guarded = [];

    public function page(): MorphToMany
    {
        return $this->morphToMany(Page::class, 'contenu', 'page_contenus');
    }

    public function getHandler(): ContenuHandler
    {
        return new class extends Controller implements ContenuHandler {
            public function single(\Bloom\CMS\Modules\Architecture\Model\Contenu $contenu): Response
            {
                return \response([
                    "status" => true
                ]);
            }

            public function multiple(Collection $contenus): Response
            {
                return \response();
            }

            public function ensemble()
            {
                return \response();
            }

            public function adminForm(): View
            {
                return view();
            }
        };
    }
}

class PageTest extends Test
{
    public function getContenu(array $attributes = []): Contenu
    {
        Relation::morphMap([
            'contenus' => Contenu::class,
        ]);

        Page::declareContenu('contenus');

        /**
         * @var Page $page
         */
        $page = factory(Page::class)->create($attributes);

        return $page->contenus()->create(
            ['html' => 'test']
        );
    }

    public function test_should_create_dynamic_polymorph_relation()
    {
        Relation::morphMap([
            'contenus' => Contenu::class,
        ]);

        Page::declareContenu('contenus');

        /**
         * @var Page $page
         */
        $page = factory(Page::class)->create();

        $a = $page->contenus()->create(
            ['html' => 'test']
        );

        $this->assertDatabaseHas('page_contenus', ['contenu_id' => $a->id, 'contenu_type' => 'contenus']);
    }

    public function test_should_auto_eager_loading_dynamiquye_contenu()
    {
        Relation::morphMap([
            'contenus' => Contenu::class,
        ]);

        Page::declareContenu('contenus');

        /**
         * @var Page $page
         */
        $page = factory(Page::class)->create();

        $a = $page->contenus()->create(
            ['html' => 'test']
        );

        $collections = $page->contenus;

        static::assertInstanceOf(Collection::class, $collections);

        $b = $collections->first();

        static::assertEquals($a->id, $b->id);
    }

    public function test_all_content_should_be_in_the_containers()
    {
        $contenu = $this->getContenu([
            'pathname' => '/test'
        ]);

        $page = $contenu->page->first();

        $containers = $page->containers;

        static::assertCount(1, $containers);

        static::assertEquals($contenu->id, $containers->first()->id);
    }

}
