<?php
/**
 *  * Created by : Jérôme Bonnier
 * Created at : 23/09/2020
 *
 * In : PhpStorm
 */

namespace Bloom\CMS\Modules\Architecture\Listeners;

use Bloom\CMS\Modules\Architecture\Events\PageArchived;
use Bloom\CMS\Modules\Architecture\Events\PageDeleted;
use Bloom\CMS\Modules\Architecture\Events\PagePublished;
use Bloom\CMS\Modules\Architecture\Events\PageUnpublished;
use Bloom\CMS\Modules\Architecture\Model\Miroir;

class PageListeners
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param object $event
     * @return void
     */
    public function handle($event)
    {
        if ($event->page->has_miroirs) {
            $miroirs = $event->page->miroir;
            foreach ($miroirs as $miroir) {
                /**
                 * @var Miroir $miroir
                 */
                if ($event instanceof PageArchived) $miroir->archive();
                if ($event instanceof PageUnpublished) $miroir->unpublish();
                if ($event instanceof PagePublished) $miroir->publish();
                if ($event instanceof PageDeleted) $miroir->softDelete();
            }
        }
    }

}