<?php


namespace Bloom\CMS\Modules\Architecture\Model;


use Bloom\CMS\Modules\Architecture\Database\Relation\BelongsToBy;
use Bloom\CMS\Modules\Architecture\Database\Relation\HasExtendedRelationships;
use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Response;
use Illuminate\View\View;

class Filtre extends Model implements Contenu
{

    use HasExtendedRelationships;

    public function page(): BelongsToBy
    {
        return $this->belongsToBy(Page::class, 'page_contenus');
    }

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu): Response
            {
                return \response();
            }

            public function multiple(Collection $contenus): Response
            {
                return \response();
            }

            public function ensemble()
            {
                return \response();
            }
        };
    }
}