<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 29/06/20
 * Time: 15:35
 */

namespace Bloom\CMS\Modules\Architecture\Database\Relation;


use Illuminate\Database\Eloquent\Concerns\HasRelationships;
use Illuminate\Support\Str;

trait HasExtendedRelationships
{
    use HasRelationships;

    /**
     * Define an inverse one-to-one or many relationship.
     *
     * @param string      $related
     * @param string      $table
     * @param string|null $foreignKey
     * @param string|null $ownerKey
     * @param string|null $relation
     *
     * @return BelongsToBy
     */
    public function belongsToBy($related, $table, $foreignKey = null, $ownerKey = null, $relation = null)
    {
        // If no relation name was given, we will use this debug backtrace to extract
        // the calling method's name and use that as the relationship name as most
        // of the time this will be what we desire to use for the relationships.
        if (is_null($relation)) {
            $relation = $this->guessBelongsToRelation();
        }

        $instance = $this->newRelatedInstance($related);

        // If no foreign key was supplied, we can use a backtrace to guess the proper
        // foreign key name by using the name of the relationship function, which
        // when combined with an "_id" should conventionally match the columns.
        if (is_null($foreignKey)) {
            $foreignKey = Str::snake($relation) . '_' . $instance->getKeyName();
        }

        // Once we have the foreign key names, we'll just create a new Eloquent query
        // for the related models and returns the relationship instance which will
        // actually be responsible for retrieving and hydrating every relations.
        $ownerKey = $ownerKey ?: $instance->getKeyName();

        return new BelongsToBy($instance->newQuery(), $this, $table, $foreignKey, $ownerKey, $relation);
    }
}