<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 29/06/20
 * Time: 15:17
 */

namespace Bloom\CMS\Modules\Architecture\Database\Relation;


use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BelongsToBy extends BelongsTo
{
    protected $table;

    public function __construct(Builder $query, Model $child, $table, $foreignKey = null, $ownerKey = null, $relationName = null)
    {
        $this->table = $table;
        
        parent::__construct($query, $child, $foreignKey, $ownerKey, $relationName);
    }


    /**
     * Set the base constraints on the relation query.
     *
     * @return void
     */
    public function addConstraints()
    {
        if (static::$constraints) {
            // For belongs to relationships, which are essentially the inverse of has one
            // or has many relationships, we need to actually query on the primary key
            // of the related models matching on the foreign key that's on a parent.
            $table = $this->table ?: $this->related->getTable();

            $this->query->where($table . '.' . $this->ownerKey, '=', $this->child->{$this->foreignKey});
        }
    }

    /**
     * Set the constraints for an eager load of the relation.
     *
     * @param array $models
     *
     * @return void
     */
    public function addEagerConstraints(array $models)
    {
        // We'll grab the primary key name of the related models since it could be set to
        // a non-standard name and not "id". We will then construct the constraint for
        // our eagerly loading query so it returns the proper models from execution.
        $table = $this->table ?: $this->related->getTable();
        $key = $table . '.' . $this->ownerKey;

        $whereIn = $this->whereInMethod($this->related, $this->ownerKey);

        $this->query->{$whereIn}($key, $this->getEagerModelKeys($models));
    }

}