import slugify from "slugify";
import SectionInfo from "./vue/SectionInfo.vue";

window.SectionInfo = SectionInfo;

document.addEventListener("DOMContentLoaded", () => {
  const BootstrapVersion = document.body.dataset.bootstrapVersion;

  if (BootstrapVersion && parseInt(BootstrapVersion.charAt(0)) > 4) {
    document
      .getElementById("whatEverModal")
      .addEventListener("shown.bs.modal", () => {
        document
          .querySelectorAll("#whatEverModal [data-dismiss]")
          .forEach((btn) => {
            btn.setAttribute("data-bs-dismiss", btn.dataset.dismiss);
            btn.removeAttribute("data-dismiss");
          });
      });
  }

  async function listenForm() {
    const formElement = document.querySelector("#form");
    if (!formElement) {
      console.error("#form element not found");
      return;
    }

    const allSites = document.querySelector(
      "#whatEverModal #form #select-all-sites"
    );
    allSites?.addEventListener("change", (e) => {
      document.querySelectorAll(".site-checkbox").forEach((site) => {
        site.checked = e.target.checked;
      });
    });
  }

  let loaded = false;
  document.querySelectorAll(".choix-sommaire-link").forEach((link) => {
    link.addEventListener("click", (e) => {
      e.preventDefault();
      const route = e.currentTarget.dataset.toload;
      const titleModal = e.currentTarget.dataset.title;
      axios
        .get(route)
        .then((response) => {
          document.getElementById("whatEverModalLabel").textContent =
            titleModal;
          const modalBody = document.querySelector(".modal-body");
          modalBody.innerHTML = response.data;

          // Exécute les scripts extraits
          const scripts = modalBody.querySelectorAll("script");
          scripts.forEach((script) => {
            const newScript = document.createElement("script");
            newScript.textContent = script.textContent;
            document.body.appendChild(newScript);
            document.body.removeChild(newScript);
          });

          if (
            BootstrapVersion &&
            parseInt(BootstrapVersion.charAt(0)) > 4 &&
            window.bootstrap
          ) {
            const modal = window.bootstrap.Modal.getOrCreateInstance(
              document.querySelector("#whatEverModal")
            );
            modal.show();
          }
        })
        .then(() => {
          listenForm();
        });
    });
  });

  document.addEventListener("edit-sommaire", (e) => {
    const titleModal = e.detail.title || "Modifier le sommaire personnalisé";
    axios
      .get(e.detail.route)
      .then((response) => {
        document.getElementById("whatEverModalLabel").textContent = titleModal;
        const modalBody = document.querySelector(".modal-body");
        modalBody.innerHTML = response.data;

        // Exécute les scripts extraits
        const scripts = modalBody.querySelectorAll("script");
        scripts.forEach((script) => {
          const newScript = document.createElement("script");
          newScript.textContent = script.textContent;
          document.body.appendChild(newScript);
          document.body.removeChild(newScript);
        });

        if (
          BootstrapVersion &&
          parseInt(BootstrapVersion.charAt(0)) > 4 &&
          window.bootstrap
        ) {
          const modal = window.bootstrap.Modal.getOrCreateInstance(
            document.querySelector("#whatEverModal")
          );
          modal.show();
        }
      })
      .then(() => {
        listenForm();
      });
  });

  document.querySelectorAll(".content .btn-group.dropleft a").forEach((btn) => {
    if (!loaded) {
      loaded = true;

      btn.addEventListener("click", () => {
        const toLoad = btn.dataset.toload;
        if (toLoad) {
          axios
            .get(toLoad)
            .then((response) => {
              const modalBody = document.querySelector(".modal-body");
              modalBody.innerHTML = response.data;

              // Exécute les scripts extraits
              const scripts = modalBody.querySelectorAll("script");
              scripts.forEach((script) => {
                const newScript = document.createElement("script");
                newScript.textContent = script.textContent;
                document.body.appendChild(newScript);
                document.body.removeChild(newScript);
              });

              if (
                BootstrapVersion &&
                parseInt(BootstrapVersion.charAt(0)) > 4 &&
                window.bootstrap
              ) {
                const modal = window.bootstrap.Modal.getOrCreateInstance(
                  document.querySelector("#whatEverModal")
                );
                modal.show();
              } else {
                $(".modal").modal();
              }
            })
            .then(() => {
              listenForm();
            });
        }
      });
    }
  });

  document.querySelector(".modal").addEventListener("input", (e) => {
    if (e.target.id === "titre") {
      document.getElementById("slug").value = slugify(e.target.value, {
        strict: true,
        remove: /\s[!.?]/g,
      })
        .replace(/(--+|-$)/gm, "")
        .toLowerCase();
    }
  });
});