import SectionInfo from "./vue/SectionInfo.vue";
import Section from "./components/Section";
import slugify from "slugify";
import {createApp} from "vue";
import jquery from "jquery";

const $ = jquery;

let loaded = false;
document.addEventListener("readystatechange", () => {
  const BootstrapVersion = document.body.dataset.bootstrapVersion;
  if (BootstrapVersion && parseInt(BootstrapVersion.charAt(0)) > 4) {
    const modalWhatEver = document.getElementById("whatEverModal");
    modalWhatEver.addEventListener("shown.bs.modal", function () {
      const btnBS5 = document
        .getElementById("whatEverModal")
        .querySelectorAll("[data-dismiss]");
      btnBS5.forEach((btn) => {
        btn.setAttribute("data-bs-dismiss", btn.dataset.dismiss);
        btn.removeAttribute("data-dismiss");
      });
    });
  }

  function listenForm() {
    let currentForm = $("#whatEverModal #form");
    if (currentForm.hasClass("sections")) {
      const sectionApp = createApp({
        components: {
          "section-info": SectionInfo,
        },
        data() {
          return {
            sections: window.Sections,
          };
        },
        computed: {},
        methods: {
          sortSections: function () {
            this.sections.sort((a, b) => {
              if (a.rang < b.rang) return -1;
              if (a.rang > b.rang) return 1;
              return 0;
            });
          },
          addSection() {
            this.sections.push(new Section(this.sections.length + 1));
          },
          removeSection(form) {
            let index = this.sections.indexOf(form);
            this.sections.splice(index, 1);
            for (let i = 0; i < this.sections.length; i++) {
              if (i >= index) {
                this.sections[i].rang--;
              }
            }
            this.sortSections();
          },
          rankUp(form) {
            let index = this.sections.indexOf(form);
            this.sections[index - 1].rang++;
            form.rang--;
            this.sortSections();
          },
          rankDown(form) {
            let index = this.sections.indexOf(form);
            this.sections[index + 1].rang--;
            form.rang++;
            this.sortSections();
          },
        },
        mounted() {
          window.bindCkfinder();
        },
      });
      sectionApp.mount("#whatEverModal #form");
    }
    if (currentForm.hasClass("move") || currentForm.hasClass("miroir")) {
      const moveOrMiroirApp = createApp({
        data() {
          let pathname = $("#whatEverModal #form")
            .find(".input-readonly.pathname")
            .text()
            .split("/");
          return {
            dossiers: window.Dossiers,
            dossier_id: "",
            slug: pathname[pathname.length - 1],
            currentPathname: pathname.join("/"),
          };
        },
        computed: {
          url() {
            if (this.dossier_id) {
              let dossier = this.dossiers.filter(
                (d) => d.id == this.dossier_id
              )[0];
              return "/" + dossier.full_pathname + "/" + this.slug;
            }
            return "/" + this.slug;
          },
        },
      });
      moveOrMiroirApp.mount("#whatEverModal #form");
    }

    //cocher /décocher tous les sites disponibles
    $("#whatEverModal #form #select-all-sites").change(function () {
      var allSites = document.querySelectorAll(".site-checkbox");

      if (allSites && allSites.length > 0) {
        if (this.checked) {
          allSites.forEach(function (site) {
            site.checked = true;
          })
        } else {
          allSites.forEach(function (site) {
            site.checked = false;
          })
        }
      }
    });
  }

  if (!loaded) {
    loaded = true;
    $(".choix-sommaire-link").click(function (e) {
      e.preventDefault();
      e.stopImmediatePropagation();
      let el = $(this),
        route = el.data("toload"),
        titleModal = el.data("title");
      axios.get(route).then((response) => {
        $("#whatEverModalLabel").text(titleModal);
        $(".modal-body").html(response.data);
        if (BootstrapVersion && parseInt(BootstrapVersion.charAt(0)) > 4 && window.bootstrap) {
          const myModalEl = document.querySelector("#whatEverModal");
          const modal = window.bootstrap.Modal.getOrCreateInstance(myModalEl);
          modal.show();
        } else {
          $(".modal").modal();
        }
      }).then(() => listenForm());
    });

    $(document).on("edit-sommaire", function (e) {
      console.log(e);
      let titleModal =
        e.detail.title !== undefined && e.detail.title !== ""
          ? e.detail.title
          : "Modifier le sommaire personnalisé";
      axios.get(e.detail.route).then((response) => {
        $("#whatEverModalLabel").text(titleModal);
        $(".modal-body").html(response.data);
        if (BootstrapVersion && parseInt(BootstrapVersion.charAt(0)) > 4 && window.bootstrap) {
          const myModalEl = document.querySelector("#whatEverModal");
          const modal = window.bootstrap.Modal.getOrCreateInstance(myModalEl);
          modal.show();
        } else {
          $(".modal").modal();
        }
      }).then(() => listenForm());
    });
    $(".content .btn-group.dropleft a").click(function () {
      let toLoad = this.dataset.toload;
      if (toLoad) {
        axios.get(toLoad).then((response) => {
          $(".modal-body").html(response.data);
          if (BootstrapVersion && parseInt(BootstrapVersion.charAt(0)) > 4 && window.bootstrap) {
            const myModalEl = document.querySelector("#whatEverModal");
            const modal = window.bootstrap.Modal.getOrCreateInstance(myModalEl);
            modal.show();
          } else {
            $(".modal").modal();
          }
        }).then(() => listenForm());
      }
    });

    $(".modal").delegate("#titre", "input", function (e) {
      $("#slug").val(
        slugify(e.target.value, {
          strict: true,
          remove: /\s[!.?]/g,
        })
          .replace(/(--+|-$)/gm, "")
          .toLowerCase()
      );
    });
  }
});
