<?php


namespace Bloom\CMS\Modules\Architecture\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Model\Contenu;
use Bloom\CMS\Modules\Architecture\Model\Dossier;
use Bloom\CMS\Modules\Architecture\Model\Ensemble;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Architecture\Model\Statut;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class PageController extends Controller
{

    public function index()
    {
        $pages = Page::published()->get();
        $archives = Page::archived()->get();

        return view('Archi::page_list', compact('pages', 'archives'));
    }

    public function edit(Page $page)
    {
        $dossiers = Dossier::all();
        $types = array_keys(Page::getDeclaredContenu());
        $statuts = Statut::all();
        $contenus = $page->containers;

        return view('Archi::page_edit', compact('page', 'dossiers', 'types', 'statuts', 'contenus'));
    }

    public function save(Page $page)
    {
        $exists = $page->exists;

        if ($exists && request('dossier_id') && $page->dossier_id != request('dossier_id')) {
            $page->pathname = str_replace($page->dossier->slug, Dossier::find(request('dossier_id'))->slug, $page->pathname);
        }
        $page->fill(request()->only([
            'titre', 'meta_titre', 'meta_description', 'slug', 'intro', 'multiplicity', 'dossier_id', 'statut_id'
        ]));

        if ($page->dossier || request('dossier_id')) {
            $dossier = Dossier::find(request('dossier_id'));
            $page->pathname = '/' . $dossier->full_pathname . '/' . $page->slug;
        } else {
            $page->pathname = '/' . $page->slug;
        }

        if (!$page->save()) {
            session()->flash('error', 'Une erreur est survenu lors de la sauvegarde');

            return redirect()->route('admin_page_list');
        }

        switch ($page->multiplicity) {
            case Page::MUTLI:
                break;
            case Page::SINGLE:
                /**
                 * @var Model|Contenu $contenu
                 */
                if ($exists) {
                    DB::table('page_contenus')
                        ->where('page_id', '=', $page->id)
                        ->update([
                            'contenu_type' => request('contenu_type'),
                            'contenu_id'   => request('contenu_id'),
                        ]);
                    $contenu = $page->containers->first();
                    $contenu->getHandler()->save($contenu, request('contenu_attributes', []));
                } else {
                    if (request('contenu_id')) {
                        $contenu = $page->containers->first();
                    } else {
                        $model = Relation::getMorphedModel(request('contenu_type'));
                        $contenu = new $model;
                    }
                    $contenu->getHandler()->save($contenu, request('contenu_attributes', []));
                    DB::table('page_contenus')->insert([
                        'page_id'      => $page->id,
                        'contenu_type' => request('contenu_type'),
                        'contenu_id'   => $contenu->id,
                        'created_at'   => now(),
                        'updated_at'   => now()
                    ]);
                }
        }


        return redirect()->route('admin_page_list');
    }

    public function contenu(string $contenu)
    {
        if (empty($contenu)) abort(404);
        /**
         * @var Contenu|Model $instance
         */
        $model = Relation::getMorphedModel($contenu);
        if (request('id')) {
            $instance = $model::find(request('id'));
        } else {
            $instance = new $model();
        }

        return $instance->getHandler()->adminForm($instance);
    }

    public function archive(Page $page)
    {
        $page->statut_id = 0;
        $page->save();

        return redirect()->route('admin_page_list');
    }

}