<?php


namespace Bloom\CMS\Modules\Architecture\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class FrontController extends Controller
{

    public function handle(Request $request)
    {
        $path = $request->getPathInfo();

        /**
         * @var Page $page
         */
        $page = Page::where('pathname', '=', $path)->firstOrFail();

        switch ($page->multiplicity) {
            case Page::SINGLE:
            case Page::ALL:
                return $page->contenu->getHandler()->single($page->contenu);
                break;
            case Page::MUTLI:
                break;
        }

        return abort(404);
    }
}