<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class PageContenuNullable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::dropIfExists('page_contenus');

        Schema::table('pages', function (Blueprint $table) {
            $table->string('contenu_type')->default(null)->nullable()->change();
            $table->integer('contenu_id', false, true)->default(null)->nullable()->change();
            $table->boolean('is_index')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('pages', function (Blueprint $table) {
            $table->string('contenu_type')->default('')->change();
            $table->integer('contenu_id', false, true)->default(0)->change();
            $table->dropColumn('is_index');
        });
    }
}
