<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePageDossiersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('page_dossiers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('page_id')->unsigned();
            $table->bigInteger('dossier_id')->default(null)->nullable()->unsigned();
            $table->bigInteger('created_by')->unsigned();
            $table->bigInteger('updated_by')->unsigned();
            $table->integer('statut_id', false, true);
            $table->string('pathname');
            $table->timestamps();

            $table->foreign(['page_id'])->references('id')->on('pages');
            $table->foreign(['dossier_id'])->references('id')->on('dossiers');
            $table->foreign(['created_by'])->references('id')->on('users');
            $table->foreign(['updated_by'])->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('page_dossiers');
    }
}
