@extends('bloom.layout.admin')

@section('assets')
    @vite('/listing.js', '/vendor/cms-module-archi')
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <div class="wrapper-titre">
                <h1>Architecture</h1>
                <h2>Historique des urls</h2>
            </div>
        </div>

        <div class="content" id="archi-listing">
            <div class="nav-menus">
                <div class="section-archi entete nav-archi-redirection">
                    <div class="pr-0 url-archi">URL</div>
                    <div class="pr-0 redirection-archi">Redirection</div>
                    <div class="pr-0 date-archi">Date de la redirection</div>
                    <div class="pr-0 btn-cta-archi"></div>
                </div>

                @foreach($redirections as $redirection)
                    <div class="nav-archi01 nav-archi-redirection">
                        <div class="section-archi section01">
                            <div class="url-archi">
                                {{ $redirection->cible }}
                            </div>
                            <div class="redirection-archi">
                                -
                            </div>
                            <div class="date-archi">
                                <span class="tooltip-elmt d-inline-block">
                                     --/--/----
                                </span>
                            </div>
                            <div class="btn-cta-archi">
                                <div class="btn-group-cta btn-group-sm text-right">
                                    <a href="{{ str_starts_with('/', $redirection->cible) ? $redirection->cible : '/' . $redirection->cible }}"
                                       class="btn btn-cta btn-grisclair5" target="_blank">
                                        Visualiser en ligne
                                    </a>
                                </div>
                            </div>
                        </div>

                        <x-modules.archi-parent
                                :parent="$redirection->parents"
                                :lvl="2"
                        />
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endsection