<script>
  window.Dossiers = {!! $dossiers !!};
</script>

<form action="{{ route('admin_archi_miroir', $page) }}" method="post" id="form" class="miroir">
    {{ csrf_field() }}

    <div class="form-group mb-4">
        <label class="control-label">
            Page maître
        </label>
        <div class="wrapper-inputs">
            <p class="m-0 input-readonly">{{ $page->titre }}</p>
        </div>
    </div>

    <div class="form-group mb-4">
        <label for="dossier_id" class="control-label">
            Emplacement de la page miroir
        </label>

        <div class="wrapper-inputs">
            <select v-model="dossier_id" class="form-control" name="dossier_id" id="dossier_id">
                <option value="">Racine</option>
                <option :value="d.id" v-for="d in dossiers">{{ '{{ d.name }}' }}</option>
            </select>
        </div>
        <p class="m-0 input-readonly pathname d-none">{{ $page->pathname }}</p>
    </div>

    <div class="form-group row mb-0">
        <div class="col-6 mb-4">
            <label class="control-label">
                URL de la page miroir
            </label>
            <div class="wrapper-inputs">
                <p class="m-0 input-readonly">{{ $url }} }}</p>
                <input name="pathname-miroir" type="hidden" :value="this.url">
            </div>
        </div>

        <div class="col-6 mb-4">
            <label class="control-label">
                Statut de la page miroir
            </label>
            <x-forms.input-custom-switch
                    name="statut_id"
                    id="statut_id"
                    :checked="$page->statut_id === 1"
                    text="Actif"
                    doubleText="Inactif"
            />
        </div>
    </div>

    <div class="wrapper-btn justify-content-center">
        <button class="btn-annuler btn btn-secondary mx-2" type="button" data-dismiss="modal">Annuler</button>
        <button class="btn-valider btn btn-grisclair5 btn-primary mx-2" type="submit">Valider</button>
    </div>
</form>