<?php


namespace Bloom\CMS\Modules\Architecture\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Model\Contenu;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Response;
use Illuminate\View\View;

interface ContenuHandler
{

    /**
     * Prend en charge l'affichage d'un contenu simple
     *
     * @param Contenu $contenu
     *
     * @return Response|View
     */
    public function single(Contenu $contenu);

    /**
     * Prend en charge l'affichage multiple
     *
     * @param Collection $contenus
     *
     * @return Response|View
     */
    public function multiple(Collection $contenus);

    /**
     * Prend en charge l'affichage d'un ensemble
     *
     * @return Response|View
     */
    public function ensemble();
}